/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration.api;

import com.floragunn.searchguard.SearchGuardVersion;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConcurrentConfigUpdateException;
import com.floragunn.searchguard.configuration.ConfigUpdateException;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchsupport.action.Action;
import com.floragunn.searchsupport.action.RestApi;
import com.floragunn.searchsupport.action.StandardRequests;
import com.floragunn.searchsupport.action.StandardResponse;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.common.inject.Inject;

public class GenericTypeLevelConfigApi {
    public static final RestApi REST_API = new RestApi().responseHeaders(SearchGuardVersion.header()).handlesDelete("/_searchguard/config/{config_type}").with((Action)DeleteAction.INSTANCE, (params, body) -> new StandardRequests.IdRequest((String)params.get("config_type"))).name("/_searchguard/config/type");

    public static class DeleteAction
    extends Action<StandardRequests.IdRequest, StandardResponse> {
        public static final String NAME = "cluster:admin:searchguard:config/delete_by_type";
        public static final DeleteAction INSTANCE = new DeleteAction();

        private DeleteAction() {
            super(NAME, StandardRequests.IdRequest::new, StandardResponse::new);
        }

        public static class Handler
        extends Action.Handler<StandardRequests.IdRequest, StandardResponse> {
            private final ConfigurationRepository configurationRepository;

            @Inject
            public Handler(Action.HandlerDependencies handlerDependencies, ConfigurationRepository configurationRepository) {
                super((Action)INSTANCE, handlerDependencies);
                this.configurationRepository = configurationRepository;
            }

            protected CompletableFuture<StandardResponse> doExecute(StandardRequests.IdRequest request) {
                return this.supplyAsync(() -> {
                    try {
                        return this.configurationRepository.delete(CType.valueOf(request.getId()));
                    }
                    catch (ConcurrentConfigUpdateException | ConfigUpdateException | IllegalArgumentException e) {
                        return new StandardResponse(e);
                    }
                });
            }
        }
    }
}

